/****** Object:  StoredProcedure [dbo].[P_GERA_RC_CREDIARIO_FECHA_DT_VENDA]    Script Date: 09/25/2013 16:30:59 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_GERA_RC_CREDIARIO_FECHA_DT_VENDA]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_GERA_RC_CREDIARIO_FECHA_DT_VENDA]
GO

/****** Object:  StoredProcedure [dbo].[P_GERA_RC_CREDIARIO_FECHA_DT_VENDA]    Script Date: 08/04/2015 15:51:04 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

 --P_GERA_RC_CREDIARIO_FECHA_DT_VENDA '20150401'
CREATE PROCEDURE [dbo].[P_GERA_RC_CREDIARIO_FECHA_DT_VENDA] ( @DT_VD DATETIME )
AS
	DECLARE  @CD_EMP INT,  @CD_FILIAL INT, @CD_VD INT;
	
	DECLARE cCredFecha  CURSOR  FOR  
	SELECT 
		V.CD_EMP,
		V.CD_FILIAL,
		V.CD_VD 
	FROM 
		RC_CREDIARIO_PARC P
		INNER JOIN RC_CREDIARIO_PARC_PDV_VD VINC ON
		P.CD_CTR	= VINC.CD_CTR 
		INNER JOIN PDV_VD V ON
		VINC.CD_EMP		= V.CD_EMP AND 
		VINC.CD_FILIAL	= V.CD_FILIAL AND 
		VINC.CD_VD		= V.CD_VD
		LEFT JOIN RC_CREDIARIO_FECHA F ON 
		P.CD_CTR = F.CD_CTR AND
		P.CD_EMP = F.CD_EMP  
	WHERE
		P.CD_EMP		=1
		AND F.CD_EMP IS NULL
		AND P.DT_LANC_CRED	>='2015-04-01'
		AND LEN(P.NR_FATURA)>'1'
		AND LEN(ISNULL(RTRIM(LTRIM(V.VS_PDV)),''))<>1
		AND P.STS_LANC_CRED=0

	OPEN cCredFecha 
	FETCH NEXT FROM cCredFecha INTO  @CD_EMP,  @CD_FILIAL, @CD_VD 
	WHILE @@FETCH_STATUS=0
	begin
		print 'Gerando RC_CREDIARIO_FECHA para filial ' + convert(varchar(5), @cd_filial) + ' Venda ' + convert(varchar, @CD_VD) ;
		EXEC P_GERA_RC_CREDIARIO_FECHA @CD_EMP,  @CD_FILIAL, @CD_VD 
		FETCH NEXT FROM cCredFecha INTO  @CD_EMP,  @CD_FILIAL, @CD_VD ; 
	end
	CLOSE cCredFecha
	DEALLOCATE cCredFecha 
GO


